connector BondPort//Base class 
 Real e;
 Real f;
end BondPort;

connector SignalPort//Base class 
 Real s;
end SignalPort;

class Node2//J1
 BondPort Port21;
 BondPort Port24;
 BondPort Port56;
 BondPort Port64;
equation
 Port21.f = Port24.f;
 Port24.f = Port56.f;
 Port56.f = Port64.f;
 -Port21.e-Port24.e-Port56.e+Port64.e = 0;
end Node2;

class Node3//J1
 BondPort Port26;
 BondPort Port30;
 BondPort Port33;
 SignalPort Port73;
 SignalPort Port130;
equation
 Port26.f = Port30.f;
 Port30.f = Port33.f;
 Port33.f = Port73.s;
 Port73.s = Port130.s;
 Port26.e-Port30.e-Port33.e = 0;
end Node3;

class Node4//GY
 BondPort Port23;
 parameter  Real 	GY = 0;
 BondPort Port27;
equation
 Port23.e = GY * Port27.f;
 Port27.e = GY * Port23.f;
end Node4;

class Node5//TF
 BondPort Port32;
 parameter  Real 	TF = 0;
 BondPort Port147;
equation
 Port32.e = TF * Port147.e;
 Port147.f = TF * Port32.f;
end Node5;

class Node7//Df
 SignalPort Port45;
 BondPort Port149;
equation
 Port45.s = Port149.f;
 Port149.e = 0;
end Node7;

class Node8//Integral
 SignalPort Port44;
 Real 	Int;
 SignalPort Port48;
equation
 Port48.s = Int;
 Port44.s = der(Int);
end Node8;

class Node9//Ds
 SignalPort Port47;
end Node9;

class Node11//R
 BondPort Port20;
 parameter  Real 	R = 0;
equation
 Port20.e = R * Port20.f;
end Node11;

class Node12//I
 BondPort Port29;
 parameter  Real 	I = 0;
 Real 	p;
equation
 Port29.e = der(p);
 p = I * Port29.f;
end Node12;

class Node13//I
 BondPort Port152;
 parameter  Real 	I = 0;
 Real 	p;
equation
 Port152.e = der(p);
 p = I * Port152.f;
end Node13;

class Node50//R
 BondPort Port155;
 parameter  Real 	R = 0;
equation
 Port155.e = R * Port155.f;
end Node50;

class Node54//I
 BondPort Port55;
 parameter  Real 	I = 0;
 Real 	p;
equation
 Port55.e = der(p);
 p = I * Port55.f;
end Node54;

class Node63//MSe
 BondPort Port65;
 SignalPort Port118;
equation
 Port65.e = Port118.s;
end Node63;

class Node68//Gain
 SignalPort Port72;
 parameter  Real 	K = 0.1;
 SignalPort Port83;
equation
 Port83.s = K * Port72.s;
end Node68;

class Node75//Gain
 SignalPort Port86;
 SignalPort Port132;
 parameter  Real 	K = 10;
equation
 Port86.s = K * Port132.s;
end Node75;

class Node76//Sum
 SignalPort Port82;
 SignalPort Port85;
 SignalPort Port123;
equation
 Port123.s = Port82.s+Port85.s;
end Node76;

class Node97//Function
 SignalPort Port143;
equation
 Port143.s=if time<0.05 then 0 else 20;
end Node97;

class Node114//Gain
 SignalPort Port119;
 SignalPort Port139;
 parameter  Real 	K = 10;
equation
 Port119.s = K * Port139.s;
end Node114;

class Node121//Gain
 SignalPort Port122;
 parameter  Real 	K = -1;
 SignalPort Port137;
equation
 Port137.s = K * Port122.s;
end Node121;

class Node128//Integral
 SignalPort Port129;
 Real 	Int;
 SignalPort Port133;
equation
 Port133.s = Int;
 Port129.s = der(Int);
end Node128;

class Node135//Sum
 SignalPort Port136;
 SignalPort Port140;
 SignalPort Port142;
equation
 Port140.s = Port136.s+Port142.s;
end Node135;

class Node145//J1
 BondPort Port146;
 BondPort Port150;
 BondPort Port153;
 BondPort Port156;
equation
 Port146.f = Port150.f;
 Port150.f = Port153.f;
 Port153.f = Port156.f;
 Port146.e-Port150.e-Port153.e-Port156.e = 0;
end Node145;

model modele13
Node2 j1_1;
Node3 j1_2;
Node4 kc;
Node5 reduc;
Node7 df_6;
Node8 integral_7;
Node9 ds_8;
Node11 R;
Node12 Jm;
Node13 Jc;
Node50 r_13;
Node54 L;
Node63 mse_2;
Node68 gain_4;
Node75 gain_5;
Node76 sum_6;
Node97 function_9;
Node114 gain_0;
Node121 gain_1;
Node128 integral_2;
Node135 sum_0;
Node145 j1_3;
equation
 connect(j1_1.Port21,R.Port20);
 connect(j1_1.Port24,kc.Port23);
 connect(kc.Port27,j1_2.Port26);
 connect(j1_2.Port30,Jm.Port29);
 connect(j1_2.Port33,reduc.Port32);
 connect(df_6.Port45,integral_7.Port44);
 connect(integral_7.Port48,ds_8.Port47);
 connect(j1_1.Port56,L.Port55);
 connect(mse_2.Port65,j1_1.Port64);
 connect(j1_2.Port73,gain_4.Port72);
 connect(gain_4.Port83,sum_6.Port82);
 connect(gain_5.Port86,sum_6.Port85);
 connect(gain_0.Port119,mse_2.Port118);
 connect(sum_6.Port123,gain_1.Port122);
 connect(j1_2.Port130,integral_2.Port129);
 connect(integral_2.Port133,gain_5.Port132);
 connect(gain_1.Port137,sum_0.Port136);
 connect(sum_0.Port140,gain_0.Port139);
 connect(function_9.Port143,sum_0.Port142);
 connect(reduc.Port147,j1_3.Port146);
 connect(j1_3.Port150,df_6.Port149);
 connect(j1_3.Port153,Jc.Port152);
 connect(j1_3.Port156,r_13.Port155);
end modele13;
